;;   Les fichiers ann.01.CLOS, puis ann.02.CLOS doivent avoir t chargs
;; pralablement.

;;   Charger ce fichier, puis valuer manuellement parmi les dernires lignes...

;;   Dfinition de quatre instances d'units linaires, destines  reproduire
;; les quatre oprations logiques de base, *linairement sparables*.

(setq uAND  (make-instance 'unite-lin :nom "uAND"
                                      :Ws  (faire-liste '(corect -0.05 0.05) 3)
                                      :nu  0.005))
(setq uNAND (make-instance 'unite-lin :nom "uNAND"
                                      :Ws  (faire-liste '(corect -0.05 0.05) 3)
                                      :nu  0.005))
(setq uOR   (make-instance 'unite-lin :nom "uOR"
                                      :Ws  (faire-liste '(corect -0.05 0.05) 3)
                                      :nu  0.005))
(setq uNOR  (make-instance 'unite-lin :nom "uNOR"
                                      :Ws  (faire-liste '(corect -0.05 0.05) 3)
                                      :nu  0.005))

;;   Impression des performances des units linaires aux diverses
;; combinaisons possibles de stimuli. L'objectif est cit aprs chaque
;; combinaison de stimuli. Leurs pondrations initiales tant alatoires, les
;; units linaires ne peuvent pas donner satisfaction ds leur cration...

(performe uAND  '(((-1 -1) -1)
                  ((-1  1) -1)
                  (( 1 -1) -1)
                  (( 1  1)  1)) :print t)
(performe uNAND '(((-1 -1)  1)
                  ((-1  1)  1)
                  (( 1 -1)  1)
                  (( 1  1) -1)) :print t)
(performe uOR   '(((-1 -1) -1)
                  ((-1  1)  1)
                  (( 1 -1)  1)
                  (( 1  1)  1)) :print t)
(performe uNOR  '(((-1 -1)  1)
                  ((-1  1) -1)
                  (( 1 -1) -1)
                  (( 1  1) -1)) :print t)

;;   Evaluer manuellement parmi les formes ci-dessous, au besoin...

;(Ws? uAND) (Ws? uNAND) (Ws? uOR) (Ws? uNOR)

;(simplifie uAND (tire uAND  '(-1 -1))) (simplifie uAND (tire uAND  '(-1  1)))
;  (simplifie uAND (tire uAND  '( 1 -1))) (simplifie uAND (tire uAND  '( 1  1)))
;(simplifie uNAND (tire uNAND '(-1 -1))) (simplifie uNAND (tire uNAND '(-1  1)))
;  (simplifie uNAND (tire uNAND '( 1 -1))) (simplifie uNAND (tire uNAND '( 1  1)))
;(simplifie uOR (tire uOR   '(-1 -1))) (simplifie uOR (tire uOR   '(-1 -1)))
;  (simplifie uOR (tire uOR   '( 1 -1))) (simplifie uOR (tire uOR   '( 1  1)))
;(simplifie uNOR (tire uNOR  '(-1 -1))) (simplifie uNOR (tire uNOR  '(-1  1)))
;  (simplifie uNOR (tire uNOR  '( 1 -1))) (simplifie uNOR (tire uNOR  '( 1  1)))

;;   Demander poliment aux units linaires de faire leur apprentissage... On
;; peut choisir l'une et/ou l'autre des deux mthodes d'apprentissage.

;Gradient Descent
;(apprendGD uAND  '(((-1 -1) -1) ((-1  1) -1) (( 1 -1) -1) (( 1  1)  1)))
;(apprendGD uNAND '(((-1 -1)  1) ((-1  1)  1) (( 1 -1)  1) (( 1  1) -1)))
;(apprendGD uOR   '(((-1 -1) -1) ((-1  1)  1) (( 1 -1)  1) (( 1  1)  1)))
;(apprendGD uNOR  '(((-1 -1)  1) ((-1  1) -1) (( 1 -1) -1) (( 1  1) -1)))

;Delta Rule (Stochastic Approximation)
;(apprend uAND  '(((-1 -1) -1) ((-1  1) -1) (( 1 -1) -1) (( 1  1)  1)))
;(apprend uNAND '(((-1 -1)  1) ((-1  1)  1) (( 1 -1)  1) (( 1  1) -1)))
;(apprend uOR   '(((-1 -1) -1) ((-1  1)  1) (( 1 -1)  1) (( 1  1)  1)))
;(apprend uNOR  '(((-1 -1)  1) ((-1  1) -1) (( 1 -1) -1) (( 1  1) -1)))

;;   Rvaluer ensuite les mthodes performe d'impression ci-dessus...